/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef ROTARYSWITCH_H
#define ROTARYSWITCH_H

#include "gpioclassv2.h"
#include <QObject>
#include <QTimer>

class RotarySwitch : public QObject
{
	Q_OBJECT

public:
	RotarySwitch(QStringList pins);
	~RotarySwitch();

public slots:
	void poll_position();
	int get_Position();

private:
	void GPIO_Preparation(QStringList pins);
	bool GPIO_Read();

	GPIOClass *GPIO_RotaryPosition;
	QList<GPIOClass*> list_RotaryPosition;
	QList<int> switch_position;
	QTimer *poll_timer;
};

#endif // ROTARYSWITCH_H

